IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_GWEB_SCRIPTS_TOT_POSTGRESQL]'))
	BEGIN
		DROP VIEW [dbo].[V_GWEB_SCRIPTS_TOT_POSTGRESQL]
	END
	
GO
CREATE VIEW [DBO].[V_GWEB_SCRIPTS_TOT_POSTGRESQL] AS
	SELECT COALESCE(SS.STS_SCRIPT, 0) AS STATUS, COUNT(*) AS TOTAL
	FROM DSYNC_CLIENT DC
	LEFT JOIN DSYNC_CH_SCRIPTS SC
		ON SC.CRC_FILE IS NOT NULL
	LEFT JOIN DSYNC_CH_SCRIPTS_STATUS SS
		ON SS.CRC_FILE = SC.CRC_FILE
		AND SS.CD_FILIAL = DC.CID
	WHERE SC.DB_ID IN (4,5)
		AND LTRIM(RTRIM(DC.CHOST)) <> 'LOCALHOST'
		AND DC.ATIVO = 1
	GROUP BY SS.STS_SCRIPT


